<?php
session_start();

if (!isset($_SESSION['usuario'])) {
    header("Location: mutual_acceso.php");
    exit;
}

$tipo = $_SESSION['tipo'];
$usuario_actual = $_SESSION['usuario'];

error_reporting(E_ALL);
ini_set('display_errors', 1);
include 'mutual_conexion.php';

// Obtener usuarios
$usuarios = $conn->query("SELECT ID_USUARIO, NOMBRE_APELLIDO FROM MUTUAL_USUARIOS");

// Obtener partes y dominios agrupados
$partes_q = $conn->query("SELECT * FROM MUTUAL_PARTE");
$partes = [];
while ($p = $partes_q->fetch_assoc()) {
    $id_parte = $p['ID_PARTE'];
    $partes[$id_parte] = [
        'nombre' => $p['NOMBRE_PARTE'],
        'dominios' => []
    ];
}

$dominios_q = $conn->query("SELECT ID_DOMINIO, ID_PARTE, NOMBRE_DOMINIO FROM MUTUAL_DOMINIO");
while ($d = $dominios_q->fetch_assoc()) {
    $partes[$d['ID_PARTE']]['dominios'][] = $d;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Registrar Evaluación</title>
    <link rel="stylesheet" href="mutual_estilo.css">
    <link rel="icon" href="iconos/01_mutual_icono_vineta.png" type="image/x-icon">
 <!--    <meta name="viewport" content="width=device-width, initial-scale=1">  -->


<style>
    form {
        max-width: 800px;
        margin: 100px auto 20px;
        padding: 20px;
        background: rgba(255, 255, 255, 0.95);
        border-radius: 10px;
        box-shadow: 0 6px 12px rgba(0,0,0,0.15);
        font-family: 'Helvetica', sans-serif;
    }

    .bloque-subida {
        border: 1px solid #ccc;
        padding: 15px;
        margin-bottom: 20px;
        border-radius: 6px;
        background: #fafafa;
    }

    legend {
        font-weight: bold;
        color: #003366;
    }

    input[type="text"],
    select,
    textarea {
        width: 100%;
        padding: 8px;
        margin: 5px 0 10px;
        border-radius: 4px;
        border: 1px solid #ccc;
        box-sizing: border-box;
        font-family: 'Helvetica', sans-serif;
    }

    .nota-parte-display {
        width: 60px;
    }

    .botones {
        text-align: center;
        margin-top: 30px;
    }

    .grabar {
        background: #04bf65;
        color: white;
        padding: 12px 24px;
        font-size: 15px;
        border: none;
        border-radius: 6px;
        cursor: pointer;
    }

    .grabar:hover {
        background: #036335;
    }

    .dominio-label {
        display: flex;
        align-items: flex-start;
        gap: 10px;
        margin-bottom: 10px;
        cursor: pointer;
        width: 100%;
    }

    .dominio-label span {
        flex: 1;
        font-size: 15px;
        line-height: 1.4;
        white-space: normal;
        word-break: break-word;
        overflow-wrap: break-word;
    }

    /* Contenedor del título fijo */
    .titulo-evaluacion-fijo {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        height: 70px;
        background: rgba(255,255,255,0.95);
        box-shadow: 0 6px 12px rgba(0,0,0,0.15);
        display: flex;
        align-items: center;
        justify-content: center;
        font-family: 'Helvetica', sans-serif;
        z-index: 999;
        user-select: none;
    }

    /* Ícono izquierda a 3cm del centro */
    .titulo-izq {
        position: absolute;
        left: calc(50% - 400px);
        top: 50%;
        transform: translateY(-50%);
    }

    /* Ícono derecha a 3cm del centro */
    .titulo-der {
        position: absolute;
        right: calc(50% - 400px);
        top: 50%;
        transform: translateY(-50%);
    }

    .titulo-izq img,
    .titulo-der img {
        height: 36px;
        width: auto;
        cursor: pointer;
    }

    .titulo-centro {
        font-size: 20px;
        font-weight: bold;
        color: #003366;
        text-align: center;
        flex-grow: 1;
    }
</style>
</head>
<body>

<div class="titulo-evaluacion-fijo">
    <div class="titulo-izq">
        <img src="iconos/13_mutual_icono_evaluar.png" alt="Evaluar" style="width: 60px; height: 60px;">
    </div>
    <div class="titulo-centro">Registrar Evaluación Completa</div>
    <div class="titulo-der">
        <a href="mutual_menueval.php" title="Volver">
            <img src="iconos/08_mutual_icono_volver.png" alt="Volver" style="width: 60px; height: 60px;">
        </a>
    </div>
</div>

<form method="POST" action="mutual_guardar_evaluacion_full.php">
    <label for="id_usuario"><strong>Usuario:</strong></label><br>
    <select name="id_usuario" id="id_usuario" class="centrar-select" required>
        <option value="">-- Selecciona usuario --</option>
        <?php while ($u = $usuarios->fetch_assoc()): ?>
            <option value="<?= $u['ID_USUARIO'] ?>"><?= htmlspecialchars($u['NOMBRE_APELLIDO']) ?></option>
        <?php endwhile; ?>
    </select><br><br>

    <?php foreach ($partes as $id_parte => $parte): ?>
        <fieldset class="bloque-subida">
            <legend><strong><?= htmlspecialchars($parte['nombre']) ?></strong></legend>

            <div id="parte_<?= $id_parte ?>">
                <?php foreach ($parte['dominios'] as $dominio):
                    $checkbox_id = "dom_{$id_parte}_{$dominio['ID_DOMINIO']}";
                ?>
                <label class="dominio-label" for="<?= $checkbox_id ?>">
                    <input type="checkbox"
                           id="<?= $checkbox_id ?>"
                           class="dominio-checkbox parte-<?= $id_parte ?>"
                           data-parte="<?= $id_parte ?>"
                           data-dominio="<?= $dominio['ID_DOMINIO'] ?>"
                           name="dominios[<?= $id_parte ?>][<?= $dominio['ID_DOMINIO'] ?>]"
                           value="1">
                    <span><?= htmlspecialchars($dominio['NOMBRE_DOMINIO']) ?></span>
                </label>
                <?php endforeach; ?>
            </div>

            <label><strong>Nota total de esta parte:</strong></label><br>
            <input type="text"
                   id="nota_parte_<?= $id_parte ?>"
                   class="nota-parte-display"
                   value="0"
                   readonly
                   style="width: 60px;"><br>

            <input type="hidden" name="nota_parte[<?= $id_parte ?>]" id="nota_parte_input_<?= $id_parte ?>" value="0">

            <label><strong>Observaciones:</strong></label><br>
            <textarea name="observaciones[<?= $id_parte ?>]"
                      rows="3"
                      cols="60"
                      placeholder="Escribe observaciones aquí..."></textarea><br>
        </fieldset>
    <?php endforeach; ?>

    <!-- Campo puntos a destacar, mejorar y accidentes -->
    <fieldset class="bloque-subida">
        <legend><strong>Comentarios Generales</strong></legend>

        <label for="puntos_destacar"><strong>Puntos a Destacar:</strong></label><br>
        <textarea name="puntos_destacar" id="puntos_destacar" rows="3" maxlength="500" placeholder="Fortalezas observadas..."></textarea><br>

        <label for="puntos_mejorar"><strong>Puntos a Mejorar:</strong></label><br>
        <textarea name="puntos_mejorar" id="puntos_mejorar" rows="3" maxlength="500" placeholder="Aspectos a mejorar..."></textarea><br>



<label for="accidentes"><strong>Cantidad de Accidentes:</strong></label><br>
<input type="number"
       name="accidentes"
       id="accidentes"
       min="0"
       max="9"
       step="1"
       style="width: 40px; text-align: center;"
       placeholder="0"
       oninput="this.value = this.value.replace(/[^0-9]/g,'').slice(0,1);"><br>




    </fieldset>

    <div class="botones">
        <button type="submit" class="grabar">
            <img src="iconos/14_mutual_icono_grabar.png" alt="Guardar" style="height:40px; vertical-align:middle; margin-right:8px;">
            Grabar Evaluación
        </button>
    </div>
</form>

<footer>
    <p>Desarrollado por sbravop@logitic.cl</p>
</footer>

<script>
<?= file_get_contents('mutual_scripts_evaluacion_por_parte.js'); ?>
</script>
</body>
</html>
