<?php
session_start();

if (!isset($_SESSION['usuario'])) {
    header("Location: mutual_acceso.php");
    exit;
}

$tipo = $_SESSION['tipo'];
$usuario_actual = $_SESSION['usuario'];

include 'mutual_conexion.php';

$evaluaciones = $conn->query("
    SELECT E.ID_EVALUACION, E.ID_USUARIO, U.NOMBRE_APELLIDO, E.FECHA_EVALUACION
    FROM MUTUAL_EVALUACION E
    JOIN MUTUAL_USUARIOS U ON E.ID_USUARIO = U.ID_USUARIO
    ORDER BY E.ID_EVALUACION DESC
");
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Lista de Evaluaciones</title>
    <link rel="stylesheet" href="mutual_estilo.css">
    <link rel="icon" href="iconos/01_mutual_icono_vineta.png" type="image/x-icon">
 <!--    <meta name="viewport" content="width=device-width, initial-scale=1">  -->
    
    <style>
        table {
            width: 90%;
            margin: 100px auto 20px;
            border-collapse: collapse;
            background-color: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 6px 12px rgba(0,0,0,0.15);
            font-family: 'Helvetica', sans-serif;
        }

        table th, table td {
            padding: 12px;
            text-align: center;
            font-size: 14px;
        }

        table tbody tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        h2 {
            text-align: center;
            margin-top: 110px;
            font-size: 20px;
            color: #003366;
        }

        .botones button {
            padding: 10px 20px;
            font-size: 14px;
            border-radius: 6px;
            border: none;
            cursor: pointer;
            background-color: #0c4896;
            color: white;
            font-family: 'Helvetica', sans-serif;
        }

        .botones button:hover {
            background-color: #06306e;
        }

        .titulo-evaluacion-fijo {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            height: 70px;
            background: rgba(255,255,255,0.95);
            box-shadow: 0 6px 12px rgba(0,0,0,0.15);
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Helvetica', sans-serif;
            z-index: 999;
            user-select: none;
        }

        .titulo-izq {
            position: absolute;
            left: calc(50% - 400px);
            top: 50%;
            transform: translateY(-50%);
        }

        .titulo-der {
            position: absolute;
            right: calc(50% - 400px);
            top: 50%;
            transform: translateY(-50%);
        }

        .titulo-izq img,
        .titulo-der img {
            height: 36px;
            width: auto;
            cursor: pointer;
        }

        .titulo-centro {
            font-size: 20px;
            font-weight: bold;
            color: #003366;
            text-align: center;
            flex-grow: 1;
        }
    </style>
</head>
<body>

<div class="titulo-evaluacion-fijo">
    <div class="titulo-izq">
        <img src="iconos/05_mutual_icono_mpver.png" alt="Evaluar" style="width: 60px; height: auto;">
    </div>
    <div class="titulo-centro">Lista de Evaluaciones</div>
    <div class="titulo-der">
        <a href="mutual_menuppl.php" title="Volver">
            <img src="iconos/08_mutual_icono_volver.png" alt="Volver" style="width: 60px; height: auto;">
        </a>
    </div>
</div>


<table>
    <thead>
        <tr>
            <th>Folio Evaluación</th>
            <th>Usuario</th>
            <th>Fecha</th>
            <th>Ver Detalle</th>
        </tr>
    </thead>
    <tbody>
        <?php while ($row = $evaluaciones->fetch_assoc()): ?>
            <tr>
                <td><?= $row['ID_EVALUACION'] ?></td>
                <td><?= htmlspecialchars($row['NOMBRE_APELLIDO']) ?></td>
                <td><?= $row['FECHA_EVALUACION'] ?></td>
                <td>
                    <div class="botones">
                        <a href="mutual_ver_evaluacion.php?id_evaluacion=<?= $row['ID_EVALUACION'] ?>">
                            <button>
                                <img src="iconos/10_mutual_icono_verdtl.png" alt="Ver" class="icono-boton" style="width:20px; height:20px; margin-right:8px; vertical-align:middle;">
                                Ver Detalles
                            </button>
                        </a>
                    </div>
                </td>
            </tr>
        <?php endwhile; ?>
    </tbody>
</table>

<footer>
    <p>Desarrollado por sbravop@logitic.cl</p>
</footer>

</body>
</html>
