<?php
// Incluir archivo de conexión

error_reporting(E_ALL);
ini_set('display_errors', 1);
?>
<?php
include 'conexion.php';

// Verificar si el formulario fue enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validar que el campo no esté vacío
    if (!empty($_POST['nombre_parte'])) {
        $nombre = trim($_POST['nombre_parte']);

        // Preparar consulta segura
        $stmt = $conn->prepare("INSERT INTO MUTUAL_PARTE (NOMBRE_PARTE) VALUES (?)");
        if ($stmt) {
            $stmt->bind_param("s", $nombre);

            if ($stmt->execute()) {
                echo "<p style='color: green;'>✔ Parte agregada correctamente.</p>";
            } else {
                echo "<p style='color: red;'>❌ Error al ejecutar la consulta: " . $stmt->error . "</p>";
            }

            $stmt->close();
        } else {
            echo "<p style='color: red;'>❌ Error en la preparación: " . $conn->error . "</p>";
        }
    } else {
        echo "<p style='color: orange;'>⚠ El campo nombre no puede estar vacío.</p>";
    }
}
?>

<h2>Agregar Parte</h2>
<form method="POST" action="">
    <label for="nombre_parte">Nombre de la parte:</label><br>
    <input type="text" id="nombre_parte" name="nombre_parte" required><br><br>
    <input type="submit" value="Guardar Parte">
</form>
