<?php
session_start();

if (!isset($_POST['id_usuario'])) {
    header("Location: mutual_acceso.php");
    exit;
}

$id_usuario = intval($_POST['id_usuario']);
$fecha = $_POST['fecha'] ?? date("Y-m-d");
$hora = $_POST['hora'] ?? date("H:i");
$observaciones = trim($_POST['observaciones'] ?? '');
$total_trabajadores = intval($_POST['total_trabajadores'] ?? 0);
$trabajadores = $_POST['trabajadores'] ?? [];
$en_hora_data = $_POST['en_hora'] ?? [];

$total_asistentes = count($trabajadores);

$dsn = "mysql:host=localhost;dbname=cpl110345_planos;charset=utf8mb4";

try {
    $conn = new PDO($dsn, "cpl110345_planosusr", "planos#####PLANOS", [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
} catch (PDOException $e) {
    die("❌ Error de conexión: " . $e->getMessage());
}

try {
    $conn->beginTransaction();

    // Insertar cabecera sin fotos
    $stmt = $conn->prepare("INSERT INTO MUTUAL_EVALUACION_DIARIA 
        (ID_USUARIO, FECHA, HORA, OBSERVACIONES, FOTO_PIZARRA, FOTO_ADICIONAL, TOTAL_TRABAJADORES, TOTAL_ASISTENTES)
        VALUES (?, ?, ?, ?, '', '', ?, ?)");
    $stmt->execute([$id_usuario, $fecha, $hora, $observaciones, $total_trabajadores, $total_asistentes]);

    $id_eval = $conn->lastInsertId();

    $nombre_foto_pizarra = '';
    $nombre_foto_adicional = '';

    $dir_destino = "Foto_diaria/";
    if (!is_dir($dir_destino)) {
        mkdir($dir_destino, 0777, true);
    }

    // Subir foto_pizarra
    if (isset($_FILES['foto_pizarra']) && $_FILES['foto_pizarra']['error'] === UPLOAD_ERR_OK) {
        $ext = strtolower(pathinfo($_FILES['foto_pizarra']['name'], PATHINFO_EXTENSION));
        $ext_permitidas = ['jpg', 'jpeg', 'png', 'webp'];
        if (in_array($ext, $ext_permitidas)) {
            $nombre_archivo = date("Ymd_His") . "_ID" . $id_eval . "_pizarra." . $ext;
            $ruta_completa = $dir_destino . $nombre_archivo;
            if (move_uploaded_file($_FILES['foto_pizarra']['tmp_name'], $ruta_completa)) {
                $nombre_foto_pizarra = $nombre_archivo;
            }
        } else {
            throw new Exception("Extensión de archivo no permitida para foto pizarra.");
        }
    }

    // Subir foto_adicional
    if (isset($_FILES['foto_adicional']) && $_FILES['foto_adicional']['error'] === UPLOAD_ERR_OK) {
        $ext = strtolower(pathinfo($_FILES['foto_adicional']['name'], PATHINFO_EXTENSION));
        $ext_permitidas = ['jpg', 'jpeg', 'png', 'webp'];
        if (in_array($ext, $ext_permitidas)) {
            $nombre_archivo = date("Ymd_His") . "_ID" . $id_eval . "_adicional." . $ext;
            $ruta_completa = $dir_destino . $nombre_archivo;
            if (move_uploaded_file($_FILES['foto_adicional']['tmp_name'], $ruta_completa)) {
                $nombre_foto_adicional = $nombre_archivo;
            }
        } else {
            throw new Exception("Extensión de archivo no permitida para foto adicional.");
        }
    }

    // Actualizar los nombres de fotos en la base de datos si se subieron
    if ($nombre_foto_pizarra !== '' || $nombre_foto_adicional !== '') {
        $stmt_upd = $conn->prepare("UPDATE MUTUAL_EVALUACION_DIARIA SET FOTO_PIZARRA = ?, FOTO_ADICIONAL = ? WHERE ID_EVALUACION_DIARIA = ?");
        $stmt_upd->execute([$nombre_foto_pizarra, $nombre_foto_adicional, $id_eval]);
    }

    // Insertar detalles
    $stmt_det = $conn->prepare("INSERT INTO MUTUAL_DETALLE_EVALUACION_DIARIA 
        (ID_EVALUACION_DIARIA, ID_TRABAJADOR, OBSERVACION, EN_HORA) VALUES (?, ?, '', ?)");

    foreach ($trabajadores as $id_trabajador) {
        $id_trabajador = intval($id_trabajador);
        $en_hora = isset($en_hora_data[$id_trabajador]) ? 1 : 0;
        $stmt_det->execute([$id_eval, $id_trabajador, $en_hora]);
    }

    $conn->commit();

    // Mostrar mensaje
    echo '
    <!DOCTYPE html>
    <html lang="es">
    <head>
        <meta charset="UTF-8">
        <title>Evaluación registrada</title>
        <link rel="stylesheet" href="mutual_estilo.css">
        <style>
            .msg {
                background: #e6ffe6;
                border: 2px solid #4CAF50;
                padding: 30px;
                border-radius: 12px;
                text-align: center;
                max-width: 500px;
                margin: 100px auto;
                box-shadow: 0 0 15px rgba(0,0,0,0.2);
                font-family: Arial, sans-serif;
            }
            .msg h2 {
                color: #2e7d32;
                margin-bottom: 10px;
            }
            .msg p {
                margin: 6px 0;
                font-size: 16px;
            }
            .msg a.btn {
                display: inline-block;
                margin-top: 20px;
                background: #4CAF50;
                color: white;
                padding: 10px 20px;
                text-decoration: none;
                border-radius: 8px;
                font-weight: bold;
            }
            .msg a.btn:hover {
                background: #388e3c;
            }
        </style>
    </head>
    <body>
        <div class="msg">
            <h2>✔ Evaluación registrada con éxito</h2>
            <p>🧾 <strong>Folio:</strong> ' . $id_eval . '</p>
            <p>📅 Fecha: <strong>' . htmlspecialchars($fecha) . '</strong> &nbsp;&nbsp; 🕒 Hora: <strong>' . htmlspecialchars($hora) . '</strong></p>
            <p>🧍 Asistentes: <strong>' . $total_asistentes . '</strong> / ' . $total_trabajadores . '</p>
            <p>📷 Foto pizarra guardada como: <strong>' . htmlspecialchars($nombre_foto_pizarra) . '</strong></p>
            <p>📷 Foto adicional guardada como: <strong>' . htmlspecialchars($nombre_foto_adicional) . '</strong></p>
            <a href="mutual_menueval.php" class="btn">Aceptar</a>
        </div>
    </body>
    </html>';

} catch (Exception $e) {
    $conn->rollBack();
    echo '❌ Error al guardar la evaluación: ' . htmlspecialchars($e->getMessage());
}
