<?php
session_start();

// Mostrar errores
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Incluir archivo de conexin
require 'mutual_conexion.php';

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['usuario'], $_POST['clave'])) {
    $usuario = $_POST['usuario'];
    $clave = $_POST['clave'];

    $stmt = $conn->prepare("SELECT * FROM MUTUAL_USUARIOS WHERE USUARIO_SIS = ?");
    $stmt->bind_param("s", $usuario);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();

    if ($user && $clave === $user['CLAVE_SIS']) {
        $_SESSION['usuario'] = $usuario;
        $_SESSION['id_usuario'] = $user['ID_USUARIO'];
        $_SESSION['tipo'] = $user['TIPO_USUARIO_SIS'];

        header("Location: mutual_menuppl.php");
        exit;
    } else {
        $error = "Usuario o contrase09a incorrectos.";
    }

    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>EvalNet</title>
    <link rel="icon" href="iconos/01_mutual_icono_vineta.png" type="image/x-icon">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="mutual_estilo.css">

    <style>
        .boton-logina {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            width: 100%;
            padding: 12px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 30px;
            font-size: 16px;
            font-family: 'Helvetica', sans-serif;
            cursor: pointer;
            transition: background-color 0.3s;
            margin-top: 10px;
        }

        .boton-logina:hover {
            background-color: #0056b3;
        }

        .contenedor-menu {
            background-color: rgba(255, 255, 255, 0.95);
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
            max-width: 400px;
            margin: 30px auto;
            text-align: center;
        }
    </style>
</head>

<body>
    <div class="fondo-leyenda">
        <p>Sistema en Modo Pruebas, @Sergio Bravo contacto +56 9 46237231</p>
    </div>

    <div class="contenedor-menu">
        <div class="titulo-menu">
            <img src="iconos/02_mutual_icono_evalnet.png" alt="Icono" style="width: 190px; height: auto;">
            <h2>Acceso al Sistema</h2>
            <h1>Evalucaiones Eficientes</h1>
        </div>

        <?php if (!empty($error)) echo "<p style='color:red;'>$error</p>"; ?>

        <form method="post">
            Usuario: <input type="text" name="usuario" required><br><br>
            Clave: <input type="password" name="clave" required><br><br>

            <button type="submit" class="boton-logina">
                <img src="icono_login.png" alt="" class="icono-botona"> Ingresar
            </button>
        </form>
    </div>

    <footer>
        <p>Desarrollado por sbravop@logitic.cl</p>
    </footer>
</body>
</html>
