<?php
session_start();

if (!isset($_SESSION['usuario'])) {
    header("Location: mutual_acceso.php");
    exit;
}

$tipo = $_SESSION['tipo'];
$usuario_actual = $_SESSION['usuario'];

ini_set('display_errors', 1);
error_reporting(E_ALL);
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

include 'mutual_conexion.php';

$id_evaluacion = $_GET['id_evaluacion'] ?? null;
if (!$id_evaluacion || !is_numeric($id_evaluacion)) {
    die("ID de evaluación no válido.");
}

// Obtener datos generales de la evaluación
$stmt_eval = $conn->prepare("
    SELECT E.*, U.NOMBRE_APELLIDO 
    FROM MUTUAL_EVALUACION E
    JOIN MUTUAL_USUARIOS U ON E.ID_USUARIO = U.ID_USUARIO
    WHERE E.ID_EVALUACION = ?
");
$stmt_eval->bind_param("i", $id_evaluacion);
$stmt_eval->execute();
$evaluacion = $stmt_eval->get_result()->fetch_assoc();

if (!$evaluacion) {
    die("Evaluación no encontrada.");
}

// Obtener partes y dominios
$partes = [];
$res_partes = $conn->query("SELECT * FROM MUTUAL_PARTE");
while ($p = $res_partes->fetch_assoc()) {
    $partes[$p['ID_PARTE']] = ['nombre' => $p['NOMBRE_PARTE'], 'dominios' => []];
}

$res_dominios = $conn->query("SELECT * FROM MUTUAL_DOMINIO");
while ($d = $res_dominios->fetch_assoc()) {
    if (isset($partes[$d['ID_PARTE']])) {
        $partes[$d['ID_PARTE']]['dominios'][] = $d;
    }
}

// Obtener detalle de parte
$detalle_parte = [];
$detalle_parte_ids = [];

$stmt_parte = $conn->prepare("SELECT * FROM MUTUAL_DETALLE_PARTE WHERE ID_EVALUACION = ?");
$stmt_parte->bind_param("i", $id_evaluacion);
$stmt_parte->execute();
$res_parte = $stmt_parte->get_result();

while ($dp = $res_parte->fetch_assoc()) {
    $id_parte = $dp['ID_MUTUAL_PARTE'];
    $id_detalle_parte = $dp['ID_MUTUAL_DETALLE_PARTE'];
    $detalle_parte[$id_parte] = $dp;
    $detalle_parte_ids[] = $id_detalle_parte;
}

// Obtener dominios seleccionados
$dominios_seleccionados = [];
if (!empty($detalle_parte_ids)) {
    $ids_in = implode(',', array_map('intval', $detalle_parte_ids));
    $res_dominios_sel = $conn->query("
        SELECT ID_MUTUAL_DOMINIO AS ID_DOMINIO, ID_MUTUAL_DETALLE_PARTE 
        FROM MUTUAL_DETALLE_DOMINIO 
        WHERE ID_MUTUAL_DETALLE_PARTE IN ($ids_in)
    ");
    while ($d = $res_dominios_sel->fetch_assoc()) {
        $id_detalle_parte = $d['ID_MUTUAL_DETALLE_PARTE'];
        $dominio_id = $d['ID_DOMINIO'];
        $dominios_seleccionados[$id_detalle_parte][] = $dominio_id;
    }
}
?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <title>Detalle de Evaluación</title>
    <link rel="stylesheet" href="mutual_estilo.css">
    <style>
        .nota-parte-display {
            width: 60px;
            font-weight: bold;
            text-align: center;
        }

        .readonly-checkbox {
            pointer-events: none;
            accent-color: #06c60b;
        }


        .dominio-label {
    display: flex;
    align-items: center;  /* Alinea verticalmente checkbox y texto */
    gap: 10px;
    margin-bottom: 10px;
    font-size: 15px;
    line-height: 1.3;
}

.dominio-label input[type="checkbox"] {
    margin: 0;               /* Elimina margen que desajusta */
    accent-color: #036335;   /* Verde más oscuro para contraste */
    transform: scale(1.3);   /* Tamaño más visible del checkbox */
}

.dominio-label span {
    margin-left: 10px;  /* espacio entre checkbox y texto */
    display: inline-block;
}



        form {
            max-width: 800px;
            margin: 100px auto 20px;
            padding: 20px;
            background: rgba(255, 255, 255, 0.95);
            border-radius: 10px;
            box-shadow: 0 6px 12px rgba(0,0,0,0.15);
            font-family: 'Helvetica', sans-serif;
        }

        /* Franja superior de título como en formulario_evaluacion */
        .titulo-evaluacion-fijo {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            height: 70px;
            background: rgba(255,255,255,0.95);
            box-shadow: 0 6px 12px rgba(0,0,0,0.15);
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Helvetica', sans-serif;
            z-index: 999;
            user-select: none;
        }

        .titulo-izq {
            position: absolute;
            left: calc(50% - 400px);
            top: 50%;
            transform: translateY(-50%);
        }

        .titulo-der {
            position: absolute;
            right: calc(50% - 400px);
            top: 50%;
            transform: translateY(-50%);
        }

        .titulo-izq img,
        .titulo-der img {
            height: 36px;
            width: auto;
            cursor: pointer;
        }

        .titulo-centro {
            font-size: 20px;
            font-weight: bold;
            color: #003366;
            text-align: center;
            flex-grow: 1;
        }

        .bloque-subida {
            border: 1px solid #ccc;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 6px;
            background: #fafafa;
        }
        
        
        /* Estilo para checkboxes marcados (visibles y claros) */
input[type="checkbox"].readonly-checkbox:checked {
    accent-color: #028a0f; /* verde oscuro compatible con navegadores modernos */
    background-color: #06c60b; /* fondo verde claro para mayor visibilidad */
    border: 2px solid #028a0f;
}

/* Mejor visibilidad del checkbox aunque esté deshabilitado */
input[type="checkbox"].readonly-checkbox {
    cursor: default;
    width: 18px;
    height: 18px;
}




.readonly-checkbox {
    position: relative;
    width: 18px;            /* achicado */
    height: 18px;           /* achicado */
    appearance: none;
    background-color: #fff;
    border: 2px solid #036335;
    border-radius: 4px;
    cursor: default;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    margin-right: 10px;     /* separación con el texto */
    vertical-align: middle;
}


.readonly-checkbox:checked {
    background-color: #036335;
}

.readonly-checkbox:checked::after {
    content: '✓';
    color: white;
    position: absolute;
    font-size: 15px;
    font-weight: bold;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
}



    </style>
</head>






<body>

<!-- Título fijo superior con íconos -->
<div class="titulo-evaluacion-fijo">
    <div class="titulo-izq">
        <img src="iconos/mutual_icono_evalua.png" alt="Evaluar" style="width: 60px; height: auto;">
    </div>
    <div class="titulo-centro">Detalle de Evaluación</div>
    <div class="titulo-der">
        <a href="mutual_lista_evaluaciones_todas.php" title="Volver">
            <img src="iconos/mutual_icono_volver.png" alt="Volver" style="width: 45px; height: 45px;">
        </a>
    </div>
</div>

<form style="margin-top: 100px;">
    <label><strong>Usuario:</strong></label>
    <p><?= htmlspecialchars($evaluacion['NOMBRE_APELLIDO']) ?></p>

    <label><strong>Fecha de Evaluación:</strong></label>
    <p><?= htmlspecialchars($evaluacion['FECHA_EVALUACION']) ?></p>

    <label><strong>Nota Final:</strong></label>
    <p><?= htmlspecialchars($evaluacion['NOTA_FINAL'] ?? '0') ?></p>

    <?php foreach ($partes as $id_parte => $parte): ?>
        <?php
        $dp = $detalle_parte[$id_parte] ?? null;
        $id_detalle_parte = $dp['ID_MUTUAL_DETALLE_PARTE'] ?? null;
        $dominios_activos = $id_detalle_parte && isset($dominios_seleccionados[$id_detalle_parte])
            ? $dominios_seleccionados[$id_detalle_parte]
            : [];
        ?>
        <fieldset class="bloque-subida">
            <legend><strong><?= htmlspecialchars($parte['nombre']) ?></strong></legend>

            <?php foreach ($parte['dominios'] as $dominio): ?>


<?php
$activo = in_array($dominio['ID_DOMINIO'], $dominios_activos);
?>
<label class="dominio-label custom-checkbox">
    <input type="checkbox"
           class="readonly-checkbox"
           <?= $activo ? 'checked' : '' ?>
           disabled>
    <span><?= htmlspecialchars($dominio['NOMBRE_DOMINIO']) ?></span>
</label>




            <?php endforeach; ?>

            <label><strong>Nota:</strong></label>
            <input type="text" readonly class="nota-parte-display"
                   value="<?= htmlspecialchars($dp['NOTA_PARTE'] ?? '0') ?>"><br>

            <label><strong>Observaciones:</strong></label><br>
            <textarea readonly rows="3" cols="60"><?= htmlspecialchars($dp['OBSERVACIONES'] ?? '') ?></textarea>
        </fieldset>
    <?php endforeach; ?>


</form>

<footer>
    <p>Desarrollado por sbravop@logitic.cl</p>
</footer>

</body>
</html>