<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

if (!isset($_SESSION['usuario'])) {
    header("Location: mutual_acceso.php");
    exit;
}

if (!isset($_GET['id_evaluacion'])) {
    echo "ID de evaluación no proporcionado.";
    exit;
}

$id_evaluacion = intval($_GET['id_evaluacion']);


include 'mutual_conexion.php';

$stmt = $conn->prepare("

    SELECT 
        d.ID_TRABAJADOR,
        t.NOMBRE_APELLIDO,
        d.ASISTENCIA,
        d.FUERA_HORA,
        d.OBSERVACION
    FROM MUTUAL_DETALLE_EVALUACION_DIARIA d
    INNER JOIN MUTUAL_TRABAJADORES t ON d.ID_TRABAJADOR = t.ID_TRABAJADOR
    WHERE d.ID_EVALUACION_DIARIA = ?
    ORDER BY t.NOMBRE_APELLIDO


");
$stmt->bind_param("i", $id_evaluacion);
$stmt->execute();
$resultado = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Detalle Evaluación</title>
    <link rel="stylesheet" href="mutual_estilo.css">
    <link rel="icon" href="iconos/mutual_icono_vineta.png" type="image/x-icon">
    <style>
        table {
            width: 95%;
            margin: 100px auto 20px;
            border-collapse: collapse;
            background-color: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 6px 12px rgba(0,0,0,0.15);
            font-family: 'Helvetica', sans-serif;
        }
        table th, table td {
            padding: 10px;
            text-align: center;
            font-size: 13px;
        }
        table td.obs {
            text-align: left;
        }
        table tbody tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        .titulo-evaluacion-fijo {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            height: 70px;
            background: rgba(255,255,255,0.95);
            box-shadow: 0 6px 12px rgba(0,0,0,0.15);
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Helvetica', sans-serif;
            z-index: 999;
            user-select: none;
        }
        .titulo-izq {
            position: absolute;
            left: calc(50% - 400px);
            top: 50%;
            transform: translateY(-50%);
        }
        .titulo-der {
            position: absolute;
            right: calc(50% - 400px);
            top: 50%;
            transform: translateY(-50%);
        }
        .titulo-izq img,
        .titulo-der img {
            height: 36px;
            width: auto;
            cursor: pointer;
        }
        .titulo-centro {
            font-size: 20px;
            font-weight: bold;
            color: #003366;
            text-align: center;
            flex-grow: 1;
        }
        
        
        .alinear-izq {
        text-align: left;
        padding-left: 60px;
        }
        
        .texto-rojo {
            color: red;
            font-weight: bold;
        }


    </style>
</head>
<body>

<div class="titulo-evaluacion-fijo">
    <div class="titulo-izq">
        <img src="iconos/mutual_icono_diaria.png" alt="Evaluar" style="width: 60px; height: auto;">
    </div>
    <div class="titulo-centro">Detalle Reunión Inicio Turno - Folio <?= $id_evaluacion ?></div>
    <div class="titulo-der">
        <a href="mutual_lista_evaluaciones_diarias_todas.php" title="Volver">
            <img src="iconos/mutual_icono_volver.png" alt="Volver" style="width: 45px; height: 45px;">
        </a>
    </div>
</div>

<table>
    <thead>
        <tr>
            <th style="width: 20%;">Trabajador</th>
            <th style="width: 15%;">Asistencia</th>
            <th style="width: 15%;">En Hora</th>
            <th style="width: 50%;">Observación</th>
            
        </tr>
    </thead>
    <tbody>
        <?php while ($row = $resultado->fetch_assoc()): ?>
            <tr>
                <td class="alinear-izq"><?= htmlspecialchars($row['NOMBRE_APELLIDO']) ?></td>
                <td><?= $row['ASISTENCIA'] ? '✔ Asistió' : '<span class="texto-rojo">✖ No Asistió' ?></td>
                <td><?= $row['FUERA_HORA'] ? '<span class="texto-rojo">✖ Fuera de Hora' : '✔ En Hora'  ?></td>
                <td class="obs"><?= htmlspecialchars($row['OBSERVACION']) ?></td>
            </tr>
        <?php endwhile; ?>
    </tbody>
</table>

<footer>
    <p>Desarrollado por sbravop@logitic.cl</p>
</footer>

</body>
</html>
