<?php
session_start();

if (!isset($_SESSION['usuario'])) {
    header("Location: mutual_acceso.php");
    exit;
}

$tipo = $_SESSION['tipo'];
$usuario_actual = $_SESSION['usuario'];
$id_usuario = $_SESSION['id_usuario'];

include 'mutual_conexion.php';

$stmt = $conn->prepare("
   SELECT 
        E.ID_EVALUACION, 
        E.FECHA_EVALUACION,
        E.NOTA_FINAL,
        E.ACCIDENTES,
        U_SUP.NOMBRE_APELLIDO AS NOMBRE_SUPERVISOR,
        U_MOV.NOMBRE_APELLIDO AS NOMBRE_MOVILIZADOR
    FROM MUTUAL_EVALUACION E
    LEFT JOIN MUTUAL_USUARIOS U_SUP ON E.ID_USUARIO = U_SUP.ID_USUARIO
    LEFT JOIN MUTUAL_USUARIOS U_MOV ON E.ID_USUARIO_MOV = U_MOV.ID_USUARIO
    ORDER BY E.ID_EVALUACION DESC
");

$stmt->execute();
$evaluaciones = $stmt->get_result();

?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Lista de Evaluaciones</title>
    <link rel="stylesheet" href="mutual_estilo.css">
    <link rel="icon" href="iconos/mutual_icono_vineta.png" type="image/x-icon">
    <style>
        table {
            width: 95%;
            margin: 100px auto 20px;
            border-collapse: collapse;
            background-color: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 6px 12px rgba(0,0,0,0.15);
            font-family: 'Helvetica', sans-serif;
        }
        table th, table td {
            padding: 10px;
            text-align: center;
            font-size: 13px;
        }
        table tbody tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        .titulo-evaluacion-fijo {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            height: 70px;
            background: rgba(255,255,255,0.95);
            box-shadow: 0 6px 12px rgba(0,0,0,0.15);
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Helvetica', sans-serif;
            z-index: 999;
            user-select: none;
        }
        .titulo-izq {
            position: absolute;
            left: calc(50% - 400px);
            top: 50%;
            transform: translateY(-50%);
        }
        .titulo-der {
            position: absolute;
            right: calc(50% - 400px);
            top: 50%;
            transform: translateY(-50%);
        }
        .titulo-izq img,
        .titulo-der img {
            height: 36px;
            width: auto;
            cursor: pointer;
        }
        .titulo-centro {
            font-size: 20px;
            font-weight: bold;
            color: #003366;
            text-align: center;
            flex-grow: 1;
        }
        .boton-ver {
            padding: 6px 14px;
            font-size: 13px;
            border: none;
            background-color: #0c4896;
            color: white;
            border-radius: 6px;
            cursor: pointer;
        }
        .boton-ver:hover {
            background-color: #06306e;
        }
    </style>
</head>
<body>

<div class="titulo-evaluacion-fijo">
    <div class="titulo-izq">
        <img src="iconos/mutual_icono_evalua.png" alt="Evaluar" style="width: 60px; height: auto;">
    </div>
    <div class="titulo-centro">Lista de Evaluaciones</div>
    <div class="titulo-der">
        <a href="mutual_menuppl.php" title="Volver">
            <img src="iconos/mutual_icono_volver.png" alt="Volver" style="width: 45px; height: 45px;">
        </a>
    </div>
</div>

<table>
    <thead>
        <tr>
            
            <th style="width: 10%;">Folio Evaluación</th>
            <th style="width: 25%;">Movilizador (Evaluador)</th>
            <th style="width: 25%;">Supervisor (Evaluado)</th>
            <th style="width: 10%;">Fecha</th>
            <th style="width: 10%;">Nota Final</th>
            <th style="width: 10%;">Accidentes</th>
            <th style="width: 10%;">Ver Detalle</th>
        </tr>
    </thead>
    <tbody>
        <?php while ($row = $evaluaciones->fetch_assoc()): ?>
            <tr>
            <td><?= $row['ID_EVALUACION'] ?></td>
            <td><?= htmlspecialchars($row['NOMBRE_MOVILIZADOR']) ?></td>
            <td><?= htmlspecialchars($row['NOMBRE_SUPERVISOR']) ?></td>
            <td><?= $row['FECHA_EVALUACION'] ?></td>
            <td><?= htmlspecialchars($row['NOTA_FINAL']) ?></td>
            <td><?= htmlspecialchars($row['ACCIDENTES']) ?></td>
  
                <td>
                    <a href="mutual_ver_evaluacion_todas.php?id_evaluacion=<?= $row['ID_EVALUACION'] ?>">
                        <button class="boton-ver">Ver Detalle</button>
                    </a>
                </td>
            </tr>
        <?php endwhile; ?>
    </tbody>
</table>

<footer>
    <p>Desarrollado por sbravop@logitic.cl</p>
</footer>

</body>
</html>
