<?php
session_start();

if (!isset($_SESSION['usuario'])) {
    header("Location: mutual_acceso.php");
    exit;
}

$tipo = $_SESSION['tipo'];
$usuario_actual = $_SESSION['usuario'];

error_reporting(E_ALL);
ini_set('display_errors', 1);
include 'mutual_conexion.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $id_usuario = intval($_POST['id_usuario']);
    $dominios_por_parte = $_POST['dominios'] ?? [];
    $notas_parte = $_POST['nota_parte'] ?? [];
    $observaciones = $_POST['observaciones'] ?? [];

    // NUEVOS CAMPOS
    $puntos_destacar = trim($_POST['puntos_destacar'] ?? '');
    $puntos_mejorar  = trim($_POST['puntos_mejorar'] ?? '');

    // ACCIDENTES: entero entre 0 y 9
    $accidentes = isset($_POST['accidentes']) ? min(max(intval($_POST['accidentes']), 0), 9) : 0;

    // FECHA Y HORA ACTUAL
    $fecha_actual = date("d/m/Y"); // dd/mm/aaaa
    $hora_actual = date("H:i");    // hh:mm

    $conn->begin_transaction();

    try {

        $id_usuario_mov = intval($_SESSION['id_usuario']);

        // Insertar evaluación con fecha y hora
        $stmt = $conn->prepare("
            INSERT INTO MUTUAL_EVALUACION 
            (ID_USUARIO, PUNTOS_DESTACAR, PUNTOS_MEJORAR, ACCIDENTES, ID_USUARIO_MOV, FECHA_EVALUACION, HORA_EVALUACION)
            VALUES (?, ?, ?, ?, ?, ?, ?)
        ");
        $stmt->bind_param("issiiss", $id_usuario, $puntos_destacar, $puntos_mejorar, $accidentes, $id_usuario_mov, $fecha_actual, $hora_actual);
        $stmt->execute();
        $id_evaluacion = $conn->insert_id;
        $stmt->close();

        // ===== CÁLCULO PROMEDIO SOBRE 7 BLOQUES =====
        $nota_total_general = 0;
        $total_bloques = 7; // siempre sobre 7 bloques

        // Recorrer partes
        for ($i = 1; $i <= $total_bloques; $i++) {
            $nota_parte = isset($notas_parte[$i]) ? floatval($notas_parte[$i]) : 0;
            $observacion = $observaciones[$i] ?? '';

            $nota_total_general += $nota_parte;

            // Insertar detalle de parte
            $stmt = $conn->prepare("
                INSERT INTO MUTUAL_DETALLE_PARTE 
                (ID_EVALUACION, ID_MUTUAL_PARTE, NOTA_PARTE, OBSERVACIONES)
                VALUES (?, ?, ?, ?)
            ");
            $stmt->bind_param("iids", $id_evaluacion, $i, $nota_parte, $observacion);
            $stmt->execute();
            $id_detalle_parte = $stmt->insert_id;
            $stmt->close();

            // Insertar dominios (si existen)
            if (isset($dominios_por_parte[$i])) {
                $stmt = $conn->prepare("
                    INSERT INTO MUTUAL_DETALLE_DOMINIO 
                    (ID_MUTUAL_DETALLE_PARTE, ID_MUTUAL_DOMINIO)
                    VALUES (?, ?)
                ");
                foreach ($dominios_por_parte[$i] as $id_dominio => $valor) {
                    $stmt->bind_param("ii", $id_detalle_parte, $id_dominio);
                    $stmt->execute();
                }
                $stmt->close();
            }
        }

        // PROMEDIO FINAL sobre 7 bloques
        $nota_total_general = $nota_total_general / $total_bloques;

        // Guardar nota final
        $stmt = $conn->prepare("
            UPDATE MUTUAL_EVALUACION 
            SET NOTA_FINAL = ? 
            WHERE ID_EVALUACION = ?
        ");
        $stmt->bind_param("di", $nota_total_general, $id_evaluacion);
        $stmt->execute();
        $stmt->close();

        $conn->commit();

        // ================== RESUMEN ==================
        $nombre_partes = [];
        $result = $conn->query("SELECT ID_PARTE, NOMBRE_PARTE FROM MUTUAL_PARTE");
        while ($row = $result->fetch_assoc()) {
            $nombre_partes[intval($row['ID_PARTE'])] = $row['NOMBRE_PARTE'];
        }

        $detalle_notas_html = "";
        for ($i = 1; $i <= $total_bloques; $i++) {
            $nombre_parte = $nombre_partes[$i] ?? "Parte $i";
            $nota = isset($notas_parte[$i]) ? $notas_parte[$i] : 0;
            $detalle_notas_html .= "<p>$nombre_parte: <strong>Nota $nota</strong></p>";
        }

        // Modal éxito
        echo '
        <!DOCTYPE html>
        <html lang="es">
        <head>
            <meta charset="UTF-8">
            <title>Evaluación registrada</title>
            <style>
                body {
                    font-family: Arial, sans-serif;
                    background: #f3f8f3;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    height: 100vh;
                }
                .msg {
                    background: #e6ffe6;
                    border: 2px solid #4CAF50;
                    padding: 30px;
                    border-radius: 12px;
                    text-align: center;
                    box-shadow: 0 0 15px rgba(0,0,0,0.2);
                }
                .msg h2 {
                    color: #2e7d32;
                }
                .msg a.btn {
                    display: inline-block;
                    margin-top: 20px;
                    background: #4CAF50;
                    color: white;
                    padding: 10px 20px;
                    text-decoration: none;
                    border-radius: 8px;
                    font-weight: bold;
                }
                .msg a.btn:hover {
                    background: #388e3c;
                }
            </style>
        </head>
        <body>
            <div class="msg">
                <h2>✔ Evaluación registrada con éxito</h2>
                <p>Fecha: <strong>'.$fecha_actual.'</strong> | Hora: <strong>'.$hora_actual.'</strong></p>
                <p>Nota final: <strong>' . number_format($nota_total_general, 2) . '</strong></p>
                ' . $detalle_notas_html . '
                <a href="mutual_menuppl.php" class="btn">Aceptar</a>
            </div>
        </body>
        </html>
        ';

    } catch (Exception $e) {
        $conn->rollback();
        echo "<p style='color:red;'>❌ Error al guardar evaluación: {$e->getMessage()}</p>";
    }

} else {
    echo "<p style='color:red;'>❌ Método no permitido.</p>";
}
?>
