// --- PARTE 1 ---
document.querySelectorAll('.parte-1').forEach(chk => {
    chk.addEventListener('change', function() {
        const checkbox15 = document.querySelector('.parte-1[data-dominio="15"]');
        const checkbox16 = document.querySelector('.parte-1[data-dominio="16"]');
        let nota = 0;

        if (checkbox15.checked && checkbox16.checked) {
            nota = 2;
        } else if (checkbox15.checked) {
            nota = 1;
        } else {
            nota = 0;
        }

        document.getElementById('nota_parte_1').value = nota;
        document.getElementById('nota_parte_input_1').value = nota;
    });
});

// --- PARTE 2 ---
document.querySelectorAll('.parte-2').forEach(chk => {
    chk.addEventListener('change', function () {
        const requiredNota1 = [17, 18, 19, 20];
        const requiredNota2 = [17, 18, 19, 20, 21, 22];

        const checked = Array.from(document.querySelectorAll('.parte-2:checked'))
            .map(cb => parseInt(cb.dataset.dominio));

        let nota = 0;
        const hasAll = ids => ids.every(id => checked.includes(id));

        if (hasAll(requiredNota2)) {
            nota = 2;
        } else if (hasAll(requiredNota1)) {
            nota = 1;
        }

        document.getElementById('nota_parte_2').value = nota;
        document.getElementById('nota_parte_input_2').value = nota;
    });
});

// --- PARTE 3 ---
document.querySelectorAll('.parte-3').forEach(chk => {
    chk.addEventListener('change', function () {
        const requiredNota1 = [23, 24];
        const requiredNota2 = [23, 24, 25, 26];

        const checked = Array.from(document.querySelectorAll('.parte-3:checked'))
            .map(cb => parseInt(cb.dataset.dominio));

        let nota = 0;
        const hasAll = ids => ids.every(id => checked.includes(id));

        if (hasAll(requiredNota2)) {
            nota = 2;
        } else if (hasAll(requiredNota1)) {
            nota = 1;
        }

        document.getElementById('nota_parte_3').value = nota;
        document.getElementById('nota_parte_input_3').value = nota;
    });
});

// --- PARTE 4 ---
document.querySelectorAll('.parte-4').forEach(chk => {
    chk.addEventListener('change', function () {
        const requiredNota1 = [27, 28, 29];
        const requiredNota2 = [27, 28, 29, 30];

        const checked = Array.from(document.querySelectorAll('.parte-4:checked'))
            .map(cb => parseInt(cb.dataset.dominio));

        let nota = 0;
        const hasAll = ids => ids.every(id => checked.includes(id));

        if (hasAll(requiredNota2)) {
            nota = 2;
        } else if (hasAll(requiredNota1)) {
            nota = 1;
        }

        document.getElementById('nota_parte_4').value = nota;
        document.getElementById('nota_parte_input_4').value = nota;
    });
});

// --- PARTE 5 ---
document.querySelectorAll('.parte-5').forEach(chk => {
    chk.addEventListener('change', function () {
        const id = parseInt(this.dataset.dominio);

        // Exclusión entre pares
        if (id === 31 && this.checked) document.querySelector('.parte-5[data-dominio="32"]').checked = false;
        if (id === 32 && this.checked) document.querySelector('.parte-5[data-dominio="31"]').checked = false;
        if (id === 33 && this.checked) document.querySelector('.parte-5[data-dominio="34"]').checked = false;
        if (id === 34 && this.checked) document.querySelector('.parte-5[data-dominio="33"]').checked = false;

        const selected = Array.from(document.querySelectorAll('.parte-5:checked'))
            .map(cb => parseInt(cb.dataset.dominio)).sort();

        let nota = 0;
        const has = ids => ids.every(id => selected.includes(id));

        if (
            (has([31, 33]) && selected.length === 2) ||
            (has([31, 34]) && selected.length === 2) ||
            (has([32, 33]) && selected.length === 2)
        ) {
            nota = 1;
        } else if (has([32, 34]) && selected.length === 2) {
            nota = 2;
        }

        document.getElementById('nota_parte_5').value = nota;
        document.getElementById('nota_parte_input_5').value = nota;
    });
});

// --- PARTE 6 ---
document.querySelectorAll('.parte-6').forEach(chk => {
    chk.addEventListener('change', function () {
        const id = parseInt(this.dataset.dominio);
        if (id === 35 && this.checked) document.querySelector('.parte-6[data-dominio="36"]').checked = false;
        if (id === 36 && this.checked) document.querySelector('.parte-6[data-dominio="35"]').checked = false;

        const dom35 = document.querySelector('.parte-6[data-dominio="35"]').checked;
        const dom36 = document.querySelector('.parte-6[data-dominio="36"]').checked;

        let nota = 0;
        if (dom35) nota = 1;
        else if (dom36) nota = 2;

        document.getElementById('nota_parte_6').value = nota;
        document.getElementById('nota_parte_input_6').value = nota;
    });
});

// --- PARTE 7 ---
document.querySelectorAll('.parte-7').forEach(chk => {
    chk.addEventListener('change', function () {
        const id = parseInt(this.dataset.dominio);
        if (id === 37 && this.checked) document.querySelector('.parte-7[data-dominio="38"]').checked = false;
        if (id === 38 && this.checked) document.querySelector('.parte-7[data-dominio="37"]').checked = false;

        const dom37 = document.querySelector('.parte-7[data-dominio="37"]').checked;
        const dom38 = document.querySelector('.parte-7[data-dominio="38"]').checked;
        const dom39 = document.querySelector('.parte-7[data-dominio="39"]').checked;
        const dom40 = document.querySelector('.parte-7[data-dominio="40"]').checked;
        const dom41 = document.querySelector('.parte-7[data-dominio="41"]').checked;
        const dom42 = document.querySelector('.parte-7[data-dominio="42"]').checked;

        let nota = 0;

        if (dom38 && dom39 && dom40 && dom41 && dom42) {
            nota = 2;
        } else if (dom37 || dom38) {
            nota = 1;
        }

        document.getElementById('nota_parte_7').value = nota;
        document.getElementById('nota_parte_input_7').value = nota;
    });
});
